/* logfile.c -- handle logfile management for ttywatch
 *
 * Copyright  2000, 2001 Michael K. Johnson <johnsonm@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __LOGFILE_H__
#define __LOGFILE_H__

#include <glib.h>
#include <unistd.h>
#include "ttywatch.h"

void
setup_logpath(char *path);
void
open_one_logfile(machine *m);
void
reopen_one_logfile(gpointer data, gpointer ignore);
void
logfile_spew(net_conn *nc);
ssize_t
logfile_write(int outfd, char *buf, size_t count);

#endif /* __LOGFILE_H__ */
