/* ttywatch.h -- log output from TTYs, based on robin.c from the book
 * Linux Application Development, by Michael K. Johnson and Erik W. Troan
 *
 * Copyright  2000, 2001 Michael K. Johnson <johnsonm@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __TTYTWATCH_H__
#define __TTYTWATCH_H__

#include <termios.h>
#include <time.h>
#include <dlfcn.h>
#include <glib.h>

/* this should really be in telnet.h, but need to short-circuit
 * the dependency
 */
typedef enum {
	TS_DATA = 0,
	TS_IAC,
	TS_SB,
	TS_SB_IAC,
} telnet_state;

typedef struct net_conn net_conn;
struct net_conn {
	struct machine *m;
	int fd;
	telnet_state ts;
};


/* Outgoing socket connection state */
typedef enum {
	SS_NOTASOCKET = 0,
	SS_INPROGRESS,
	SS_CONNECTED,
	SS_TIMEOUT,
} socket_state;

typedef struct machine machine;
struct machine {
	char *name;
	char *devpath;
	char *ipport;
	char *ipaddr;
	int logspew;
	void (*process_line)(machine *m, char *data);
	void *modhandle;
	void *moddata;          /* reserved for module use */
	net_conn dev_nc;        /* might be a plain file or a net connection */
	socket_state ss;        /* describes dev_fd */
	time_t timeout_expires; /* when to try again if ss == SS_TIMEOUT */
	volatile int log_fd;    /* volatile because modified from signal handler */
	int accept_fd;
	GSList *net_conns;
	speed_t speed;
	struct termios ots;
	struct termios ts;
};

#if DEBUGGING
#define D printf
#else
#define D(...) do { } while (0)
#endif

#endif /* __TTYTWATCH_H__ */
