Name: ttywatch
Version: 0.9
Release: 1
Summary: Log output of arbitrarily many devices
Copyright: GPL
Group: System Environment/Daemons
Source: ttywatch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Prereq: /sbin/chkconfig /usr/bin/install

%description
ttywatch was originally designed to log serial console output from
lots of Linux machines on a single monitor machine.  It handles
log rotation correctly and can be configured both in a configuration
file and on the command line -- and you can mix-and-match at your
convenience.  It can be set up to allow users to interact via the
network with any of the ports being logged.  It can also log output
in arbitrary ways via modules, which can be built with the
ttywatch-devel package.

%package devel
Summary: Build modules for the ttywatch daemon
Group: Development/System

%description devel
Includes the ttywatch.h header file used to build ttywatch modules.

%prep
%setup

%build
make

%install
[ "$RPM_BUILD_ROOT" = "/" ] && {
	echo 'this package must build in a buildroot' >&2
	exit 1
}

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

make install TOPDIR=$RPM_BUILD_ROOT

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add ttywatch
if [ "$1" = 1 ]; then
    # For initial install only, create logfile directory.
    # We do not want to package this directory as owned by rpm,
    # because if we do, rpm resets the permissions at every
    # install, and we only want to set a default that the
    # sysadmin can override with impunity.
    install -d --owner=0 --group=0 --mode=700 /var/log/ttywatch
fi

%preun
if [ "$1" = 0 ]; then
    service ttywatch stop > /dev/null 2>&1
    /sbin/chkconfig --del ttywatch
fi

%postun
if [ "$1" -ge "1" ]; then
    service ttywatch condrestart > /dev/null 2>&1
fi

%files
%defattr(-,root,root)
%attr(0755,root,root) /usr/sbin/*
%attr(0755,root,root) /etc/rc.d/init.d/ttywatch
%config(noreplace) %attr(0644,root,root) /etc/ttywatch.conf
%config(noreplace) %attr(0644,root,root) /etc/logrotate.d/ttywatch
%attr(0644,root,root) /usr/share/man/man*/*

%files devel
%defattr(-,root,root)
%attr(0644,root,root) /usr/include/*

%changelog
* Fri Jun 22 2001 Michael K. Johnson <johnsonm@redhat.com>
- Added telnet "send break" handling (0.9)

* Fri May 11 2001 Michael K. Johnson <johnsonm@redhat.com>
- Do not package /var/log/ttywatch, just create it out of the post
  on new installs.

* Tue May 01 2001 Michael K. Johnson <johnsonm@redhat.com>
- Be careful what you ask for; you just might get it.  :-)
  More careful error handling accidentally broke log rotation handling,
  fixed. (0.8)

* Sat Apr 28 2001 Michael K. Johnson <johnsonm@redhat.com>
- Fixed memory leak and early process death on network disconnect (0.7)

* Wed Apr 25 2001 Michael K. Johnson <johnsonm@redhat.com>
- Added the ability to connect to and interact with ports
  via the network. (0.6)

* Tue Dec 19 2000 Michael K. Johnson <johnsonm@redhat.com>
- Releasing 0.5

* Tue Dec 12 2000 Michael K. Johnson <johnsonm@redhat.com>
- added "notifempty" to default logrotate, plus comment on rotate --
  hopefully last config file change for a while

* Mon Dec 11 2000 Michael K. Johnson <johnsonm@redhat.com>
- chdir was breaking relative paths, so I removed it

* Mon Dec 04 2000 Michael K. Johnson <johnsonm@redhat.com>
- Added facility for log modules.
- Added -devel package for building log modules

* Wed Nov 01 2000 Michael K. Johnson <johnsonm@redhat.com>
- Releasing 0.3
- Fixed log file re-opening to use the .log suffix

- Releasing 0.2, first public version
- License notice added
- Code cleanup
- Nested config files fixed
- Documentation touch-ups

* Thu Sep 15 2000 Michael K. Johnson <johnsonm@redhat.com>
- initial version
